ORCA/M Asm65816 2.1.0

0001 B446                       TITLE ', RESTART.a - Restart'
0002 B446              *
0003 B446              ****************************************************************
0004 B446              *
0005 B446              *              Restart ($0A)
0006 B446              *
0007 B446              *  Inputs:     UserID (2 bytes)
0008 B446              *  Outputs:    UserID (2 bytes)
0009 B446              *              Starting Address (4 bytes)
0010 B446              *              Address of Zero Page/Stack (2 bytes)
0011 B446              *              Size of Zero Page/Stack (2 bytes)
0012 B446              *  Errors:     $0000 - Operation successful
0013 B446              *              $1101 - Application not found
0014 B446              *              $1108 - UserID error
0015 B446              *              $00xx - ProDOS I/O error
0016 B446              *              $02xx - Memory Manager error
0017 B446              *
0018 B446              ****************************************************************
0019 B446              *
0020 B446              Restart  PROC 
0021 B446                       LoadSegCheck 
0022 B446
0023 B446                       with DirectPage, Globals
0024 B446                       Import find_user_id,merge_path,lock_statics, \
0025 B446                       remove_segment,open_load_file,load_statics, \ 
0026 B446                       close_load_file,save_start,save_dp,restore_dp, \ 
0027 B446                       delete_user_id,zero_handles,check_express_seg,get_express_seg 
0028 B446
0029 B446 A2 02 00              ldx   #func_0A_param_cnt       ;get the number of parameters of the stack
0030 B449 20 C6 B9              jsr   get_parameters
0031 B44C
0032 B44C              IUserID  equ   input_parms              ;input  UserID
0033 B44C              OUserID  equ   1                        ;output UserID
0034 B44C              OAddress equ   OUserID+2                ;output Load Address
0035 B44C              OZP_Addr equ   OAddress+4               ;output Zero Page/Stack Address
0036 B44C              OZP_Size equ   OZP_Addr+2               ;output Zero Page/Stack Size
0037 B44C
0038 B44C A5 E0                 lda   IUserID                  ;lets see if we know about this user ID
0039 B44E 20 67 D4              jsr   find_user_id             ;If found temp_ptr setup
0040 B451 90 03                 bcc   @continue
0041 B453 82 A4 00              brl   old_loader               ;not my job
0042 B456              @continue  
0043 B456              ;
0044 B456              ;At this point all errors that we encounter must be returned to the caller since the file is mine.
0045 B456              ;
0046 B456
0047 B456 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
0048 B459 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
0049 B45B AA                    tax   
0050 B45C C8                    iny   
0051 B45D C8                    iny   
0052 B45E B7 62                 lda   [temp_ptr],y
0053 B460 A8                    tay   
0054 B461 D0 0A                 bne   @have_handle
0055 B463 8A                    txa   
0056 B464 D0 07                 bne   @have_handle             ;we have the handle
0057 B466 A9 F2 11              lda   #ExpressSegLost
0058 B469 38                    sec   
0059 B46A 4C F6 B4              jmp   @error_exit              ;report error to the caller.
0060 B46D              @have_handle  
0061 B46D 20 46 D3              jsr   merge_path               ;we now have the expanded ExpressLoad pathname
0062 B470
0063 B470 20 06 B7              jsr   chk_mod_date             ;make sure the file hasn't changed
0064 B473 D0 0C                 bne   @must_reload             ;it's changed, reload the whole thing
0065 B475
0066 B475 20 9C E0              jsr   lock_statics             ;lock the static segments please
0067 B478 B0 07                 bcs   @must_reload             ;something got purged...
0068 B47A 20 CD B6              jsr   kick_start
0069 B47D B0 77                 bcs   @error_exit              ;report error to the caller.
0070 B47F 80 52                 bra   @clean_exit
0071 B481              ;
0072 B481              ;If we get here we need to remove the old info and reload the application from disk
0073 B481              ;
0074 B481              @must_reload  
0075 B481 A0 04 00              ldy   #4                       ;lock the ExpressSeg handle
0076 B484 B7 88                 lda   [ExpressHandle],y
0077 B486 09 00 80              ora   #$8000
0078 B489 97 88                 sta   [ExpressHandle],y
0079 B48B
0080 B48B A9 00 00              lda   #purge_all               ;remove all segments
0081 B48E A2 00 00              ldx   #$0000                   ;LOAD flags AND mask COMPARE value BEQ REMOVE_IT
0082 B491 20 17 D4              jsr   remove_segment           ;deallocate the segments
0083 B494
0084 B494 A5 CE                 lda   PathnamePtr              ;make a copy of the pathname
0085 B496 A4 D0                 ldy   PathnamePtr+2
0086 B498 20 96 F7              jsr   Expand_Pathname
0087 B49B A5 18                 lda   TempBuff                 ;copy pointer to PathnamePtr
0088 B49D 85 CE                 sta   PathnamePtr
0089 B49F A5 1A                 lda   TempBuff+2
0090 B4A1 85 D0                 sta   PathnamePtr+2
0091 B4A3
0092 B4A3 A9 01 00              lda   #keep_id                 ;indicate that we must keep the ID
0093 B4A6 20 BE D3              jsr   delete_user_id
0094 B4A9 20 EE E4              jsr   zero_handles             ;reset everything
0095 B4AC
0096 B4AC 20 69 DD              jsr   open_load_file           ;open the file
0097 B4AF B0 45                 bcs   @error_exit
0098 B4B1 20 2D DB              jsr   check_express_seg        ;read ExpressLoad segment header in
0099 B4B4 B0 40                 bcs   @error_exit              ;just in case...
0100 B4B6 20 15 DC              jsr   get_express_seg          ;load the ExpressLoad segment
0101 B4B9 B0 3B                 bcs   @error_exit              ;report error to the caller
0102 B4BB
0103 B4BB 64 B2                 stz   spec_mem_flag            ;allow special memory if necessary
0104 B4BD 20 91 E3              jsr   load_statics             ;load all the static segments
0105 B4C0 08                    php                            ;save carry
0106 B4C1 48                    pha                            ;save possible error code
0107 B4C2 20 2E DD              jsr   close_load_file          ;close the file and restore sys_prefs
0108 B4C5 F4 08 70              pea   uTempBuff                ;dispose of temporary pathname
0109 B4C8 A2 02 11 22           _DisposeAll 
0110 B4CF 68                    pla                            ;restore error code
0111 B4D0 28                    plp                            ;restore carry
0112 B4D1 B0 23                 bcs   @error_exit              ;report error to the caller.
0113 B4D3              @clean_exit  
0114 B4D3 20 05 E4              jsr   save_start
0115 B4D6 A5 DC                 lda   stack_size               ;return the correct parameters
0116 B4D8 83 09                 sta   OZP_Size,s
0117 B4DA A5 DA                 lda   stack_addr
0118 B4DC 83 07                 sta   OZP_Addr,s
0119 B4DE AD A8 A6              lda   starting_addr+2          ;address of the Application
0120 B4E1 29 FF 00              and   #$00FF
0121 B4E4 83 05                 sta   OAddress+2,s
0122 B4E6 AD A6 A6              lda   starting_addr
0123 B4E9 83 03                 sta   OAddress,s
0124 B4EB AD B6 A6              lda   |USERID
0125 B4EE 83 01                 sta   OUserID,s
0126 B4F0 A9 00 00              lda   #$0000
0127 B4F3              @outta_here  
0128 B4F3 4C 1B BA              jmp   return_to_caller         ;we were successful!!
0129 B4F6
0130 B4F6              @error_exit  
0131 B4F6 A6 E0                 ldx   IUserID
0132 B4F8 D0 F9                 bne   @outta_here              ;If the user_id was zero let Lou try.
0133 B4FA
0134 B4FA              old_loader  
0135 B4FA 20 38 B4              jsr   InitInit                 ;common initialize
0136 B4FD              ;
0137 B4FD              ;        initialize output variables
0138 B4FD              ;
0139 B4FD A9 00 00              lda   #0
0140 B500 83 03                 sta   OAddress,s               ;zero output address
0141 B502 83 05                 sta   OAddress+2,s
0142 B504              ;
0143 B504              ;        if Main ID field of input UserID is 0, error
0144 B504              ;
0145 B504 A5 E0                 lda   IUserID
0146 B506 29 FF 00              and   #$FF
0147 B509 D0 05                 bne   cont1
0148 B50B A9 08 11              lda   #BadUser
0149 B50E 80 2E                 bra   error_skip
0150 B510              ;
0151 B510              ;        look for Pathname Table entry corresponding to UserID
0152 B510              ;
0153 B510 D4 E0        cont1    pei   IUserID                  ;UserID
0154 B512 A9 01 00              lda   #1
0155 B515 48                    pha                            ;FileNum
0156 B516 3A                    dec   a
0157 B517 48                    pha                            ;Address of pathname (none)
0158 B518 48                    pha   
0159 B519 20 7B F6              jsr   Find_Pathname
0160 B51C B0 19                 bcs   cont1a
0161 B51E              ;
0162 B51E              ;        extract data from Pathname Table entry
0163 B51E              ;
0164 B51E BD 08 00              lda   |PT_UserID,x
0165 B521 83 01                 sta   OUserID,s
0166 B523 BD 14 00              lda   |PT_ZP_Addr,x
0167 B526 83 07                 sta   OZP_Addr,s
0168 B528 BD 16 00              lda   |PT_ZP_Size,x
0169 B52B 83 09                 sta   OZP_Size,s
0170 B52D BD 1A 00              lda   |PT_Address,x
0171 B530 83 03                 sta   OAddress,s
0172 B532 BD 1C 00              lda   |PT_Address+2,x
0173 B535 83 05                 sta   OAddress+2,s
0174 B537              ;
0175 B537              ;        check if Pathname Table entry actually found
0176 B537              ;
0177 B537 4B           cont1a   phk   
0178 B538 AB                    plb                            ;restore DBR
0179 B539 A9 01 11              lda   #NoFind
0180 B53C 90 03                 bcc   _1
0181 B53E              error_skip  
0182 B53E 4C BC B6              jmp   Error_Exit
0183 B541              _1        
0184 B541              ;
0185 B541              ;        UserID is known to System Loader, save as USERID
0186 B541              ;
0187 B541 A5 E0                 lda   IUserID
0188 B543 8D B6 A6              sta   |USERID
0189 B546              ;
0190 B546              ;        extract pathname from Pathname Table entry
0191 B546              ;
0192 B546 20 0D F7              jsr   Get_Pathname
0193 B549 B0 F3                 bcs   error_skip
0194 B54B              ;
0195 B54B              ;        Counter will count # of dynamic segments encountered
0196 B54B              ;
0197 B54B 64 14                 stz   Counter
0198 B54D              ;
0199 B54D              ;        zero handle to first Memory Segment Table entry
0200 B54D              ;
0201 B54D 64 34                 stz   FirstMemSeg
0202 B54F 64 36                 stz   FirstMemSeg+2
0203 B551              ;
0204 B551              ;        set start of Memory Segment search to begining of Table
0205 B551              ;
0206 B551 AD AA A6              lda   |SEGTBL
0207 B554 85 08                 sta   Handle
0208 B556 AD AC A6              lda   |SEGTBL+2
0209 B559 85 0A                 sta   Handle+2
0210 B55B              ;
0211 B55B              ;        search Memory Segment Table for Load File Segments for
0212 B55B              ;        this UserID
0213 B55B              ;
0214 B55B A9 00 00     loop1    lda   #0                       ;output Handle
0215 B55E 48                    pha   
0216 B55F 48                    pha   
0217 B560 D4 E0                 pei   IUserID                  ;UserID
0218 B562 48                    pha                            ;File Number (all)
0219 B563 48                    pha                            ;Segment Number (all)
0220 B564 20 7A F8              jsr   Next_MemSeg              ;find next Load Segment
0221 B567 68                    pla   
0222 B568 85 00                 sta   TempZero                 ;output Handle
0223 B56A 68                    pla   
0224 B56B 85 02                 sta   TempZero+2
0225 B56D              ;
0226 B56D              ;        if entry found then:
0227 B56D              ;
0228 B56D              ;              1) if 1st entry found, set FirstMemSeg to entry handle
0229 B56D              ;              2) process entry
0230 B56D              ;
0231 B56D              ;        if entry not found then:
0232 B56D              ;
0233 B56D              ;              1) if no entries found, application is incomplete
0234 B56D              ;              2) if some entries found, application is complete
0235 B56D              ;
0236 B56D A5 34                 lda   FirstMemSeg
0237 B56F 05 36                 ora   FirstMemSeg+2            ;A=0 means no entries found yet
0238 B571 90 08                 bcc   cont3
0239 B573 F0 03                 beq   cont2
0240 B575              ;
0241 B575              ;        entry not found but some have been found, application is complete
0242 B575              ;
0243 B575 4C D5 B5              jmp   complete                 ;no more, all found
0244 B578              ;
0245 B578              ;        entry not found and none have been found, application is incomplete
0246 B578              ;
0247 B578 4C 7B B6     cont2    jmp   incomplete
0248 B57B              ;
0249 B57B              ;        entry found, if not first, process
0250 B57B              ;
0251 B57B D0 08        cont3    bne   cont4
0252 B57D              ;
0253 B57D              ;        entry found and its the first, set FirstMemSeg to handle of entry
0254 B57D              ;
0255 B57D A5 00                 lda   TempZero
0256 B57F 85 34                 sta   FirstMemSeg
0257 B581 A5 02                 lda   TempZero+2
0258 B583 85 36                 sta   FirstMemSeg+2
0259 B585              ;
0260 B585              ;        if memory segment is for a dynamic segment, dispose it
0261 B585              ;        and if this is the first dynamic segment encountered,
0262 B585              ;        unload all Jump Table entries for this UserID
0263 B585              ;
0264 B585              ;        normally a dynamic segment would already be purged but
0265 B585              ;        if an application was not shut-down, dynamic segments
0266 B585              ;        are still in memory.  This will mess up the logic further
0267 B585              ;        on which makes all segments unpurgeable (i.e. static).
0268 B585              ;
0269 B585 BD 12 00     cont4    lda   |MS_Kind,x
0270 B588 89 00 80              bit   #Dyn_Segment
0271 B58B F0 2D                 beq   cont6
0272 B58D
0273 B58D DA                    phx                            ;save X
0274 B58E
0275 B58E BD 0C 00              lda   |MS_Handle+2,x
0276 B591 48                    pha   
0277 B592 BD 0A 00              lda   |MS_Handle,x
0278 B595 48                    pha   
0279 B596 A2 02 10 22           _DisposeHandle                 ;error is OK
0280 B59D
0281 B59D FA                    plx                            ;restore X
0282 B59E 9E 0A 00              stz   |MS_Handle,x
0283 B5A1 9E 0C 00              stz   |MS_Handle+2,x
0284 B5A4
0285 B5A4 A5 14                 lda   Counter                  ;is this first dynamic segment?
0286 B5A6 D0 0E                 bne   cont5                    ;if not, skip unload JTL entries
0287 B5A8
0288 B5A8 BD 08 00              lda   |MS_UserID,x             ;UserID
0289 B5AB 48                    pha   
0290 B5AC A9 00 00              lda   #0
0291 B5AF 48                    pha                            ;File Number (all)
0292 B5B0 48                    pha                            ;Segment Number (all)
0293 B5B1 4B                    phk                            ;restore DBR
0294 B5B2 AB                    plb   
0295 B5B3 20 19 F9              jsr   Unload_JTL
0296 B5B6
0297 B5B6 E6 14        cont5    inc   Counter                  ;bump dynamic segment counter
0298 B5B8
0299 B5B8 80 16                 bra   eloop1
0300 B5BA              ;
0301 B5BA              ;        check memory segment handle in entry to see if segment in memory.
0302 B5BA              ;
0303 B5BA BD 0A 00     cont6    lda   |MS_Handle,x             ;if memory segment handle is 0,
0304 B5BD 1D 0C 00              ora   |MS_Handle+2,x           ;  handle has been disposed
0305 B5C0 F0 0B                 beq   cont7
0306 B5C2 BD 0A 00              lda   |MS_Handle,x             ;memory segment handle
0307 B5C5 BC 0C 00              ldy   |MS_Handle+2,x
0308 B5C8 20 D6 FA              jsr   DeRef                    ;dereference
0309 B5CB 90 03                 bcc   eloop1
0310 B5CD 4C 7B B6     cont7    jmp   incomplete               ;if NIL, Application incomplete
0311 B5D0 4B           eloop1   phk                            ;restore original DBR
0312 B5D1 AB                    plb   
0313 B5D2
0314 B5D2 4C 5B B5              jmp   loop1
0315 B5D5              ;
0316 B5D5              ;        all segments appear to be in memory.  Lock and make all segments
0317 B5D5              ;        unpurgeable.
0318 B5D5              ;
0319 B5D5 4B           complete phk                            ;restore DBR
0320 B5D6 AB                    plb   
0321 B5D7              ;
0322 B5D7              ;        scan through segments again
0323 B5D7              ;
0324 B5D7              ;
0325 B5D7              ;        set start of Memory Segment search to FirstMemSeg
0326 B5D7              ;
0327 B5D7 A5 34                 lda   FirstMemSeg
0328 B5D9 85 08                 sta   Handle
0329 B5DB A5 36                 lda   FirstMemSeg+2
0330 B5DD 85 0A                 sta   Handle+2
0331 B5DF
0332 B5DF A9 00 00     loop2    lda   #0                       ;output Handle
0333 B5E2 48                    pha   
0334 B5E3 48                    pha   
0335 B5E4 D4 E0                 pei   IUserID                  ;UserID
0336 B5E6 48                    pha                            ;File Number (all)
0337 B5E7 48                    pha                            ;Segment Number (all)
0338 B5E8 20 7A F8              jsr   Next_MemSeg              ;find next Load Segment
0339 B5EB 68                    pla   
0340 B5EC 85 00                 sta   TempZero                 ;output Handle
0341 B5EE 68                    pla   
0342 B5EF 85 02                 sta   TempZero+2
0343 B5F1 90 03                 bcc   cont8
0344 B5F3 4C 6B B6              jmp   cont10
0345 B5F6              ;
0346 B5F6              ;        if this segment is a Reload Segment, then reload it using same address
0347 B5F6              ;
0348 B5F6 BD 12 00     cont8    lda   |MS_Kind,x
0349 B5F9 89 00 04              bit   #Reload_Segment
0350 B5FC F0 36                 beq   cont9
0351 B5FE DA                    phx                            ;save X
0352 B5FF 8B                    phb                            ;save DBR
0353 B600 D4 0A                 pei   Handle+2                 ;save Handle
0354 B602 D4 08                 pei   Handle
0355 B604 A9 00 00              lda   #0                       ;output address
0356 B607 48                    pha   
0357 B608 48                    pha   
0358 B609 BD 08 00              lda   |MS_UserID,x             ;UserID
0359 B60C 48                    pha   
0360 B60D BD 0E 00              lda   |MS_FileNum,x            ;File Number
0361 B610 48                    pha   
0362 B611 BD 10 00              lda   |MS_SegNum,x             ;Segment Number
0363 B614 48                    pha   
0364 B615 BD 0A 00              lda   |MS_Handle,x             ;memory segment handle
0365 B618 BC 0C 00              ldy   |MS_Handle+2,x           ;memory segment handle
0366 B61B 20 D6 FA              jsr   DeRef                    ;get memory address
0367 B61E 5A                    phy   
0368 B61F 48                    pha                            ;Segment Address
0369 B620 4B                    phk                            ;restore DBR
0370 B621 AB                    plb   
0371 B622 20 B2 E6              jsr   Find_Segment
0372 B625 68                    pla                            ;output address
0373 B626 68                    pla                            ;(not used)
0374 B627
0375 B627 68                    pla   
0376 B628 85 08                 sta   Handle                   ;restore Handle
0377 B62A 68                    pla   
0378 B62B 85 0A                 sta   Handle+2
0379 B62D AB                    plb                            ;restore DBR
0380 B62E FA                    plx                            ;restore X
0381 B62F 90 19                 bcc   eloop2
0382 B631              error_skip_2  
0383 B631 4C BC B6              jmp   Error_Exit
0384 B634              ;
0385 B634              ;        if this segment is an Initialization Segment, execute it
0386 B634              ;
0387 B634 29 1F 00     cont9    and   #$1F
0388 B637 C9 10 00              cmp   #Init_Segment
0389 B63A D0 0E                 bne   eloop2
0390 B63C DA                    phx                            ;save X
0391 B63D BD 0A 00              lda   |MS_Handle,x             ;handle to segment in memory
0392 B640 BC 0C 00              ldy   |MS_Handle+2,x
0393 B643 20 D6 FA              jsr   DeRef                    ;dereference handle (A,Y - address)
0394 B646 20 4A E9              jsr   Do_Init_Segment
0395 B649 FA                    plx                            ;restore X
0396 B64A
0397 B64A              eloop2    
0398 B64A              ;
0399 B64A              ;        lock and make purgeable handle to memory for Load Segment
0400 B64A              ;
0401 B64A F4 00 00              pea   0                        ;Purge Level (purgeable) for SetPurge call
0402 B64D BD 0C 00              lda   |MS_Handle+2,x           ;Handle
0403 B650 48                    pha   
0404 B651 A8                    tay                            ;save for a bit
0405 B652 BD 0A 00              lda   |MS_Handle,x
0406 B655 48                    pha   
0407 B656
0408 B656 5A                    phy                            ;again for HLock call
0409 B657 48                    pha   
0410 B658 A2 02 20 22           _HLock 
0411 B65F
0412 B65F A2 02 24 22           _SetPurge 
0413 B666 4B                    phk                            ;restore original DBR
0414 B667 AB                    plb   
0415 B668
0416 B668 4C DF B5              jmp   loop2
0417 B66B
0418 B66B 4B           cont10   phk                            ;restore DBR
0419 B66C AB                    plb   
0420 B66D              ;
0421 B66D              ;        purge all other memory segments that are still floating around
0422 B66D              ;
0423 B66D D4 E0                 pei   IUserID                  ;UserID
0424 B66F A2 02 13 22           _PurgeAll 
0425 B676
0426 B676 A9 00 00              lda   #0                       ;signify no error
0427 B679 80 41                 bra   Error_Exit
0428 B67B              ;
0429 B67B              ;        not enough information is left in memory to restart the application.
0430 B67B              ;
0431 B67B 4B           incomplete phk                          ;restore DBR
0432 B67C AB                    plb   
0433 B67D              ;
0434 B67D              ;        do UserShutdown for UserID.  The ShutDown will look like a 'Reload'
0435 B67D              ;        shutdown except that the Pathname table is also purged of the UserID.
0436 B67D              ;        So what we are actually doing is removing everything that has to do
0437 B67D              ;        with the UserID except we are not removing the UserID itself. The
0438 B67D              ;        reason we do not want to remove the UserID is that we are about to do
0439 B67D              ;        an Initial Load with that UserID.
0440 B67D              ;
0441 B67D 20 ED FA              jsr   save_dp                  ;save our direct page
0442 B680 48                    pha                            ;make space for returned UserID
0443 B681 A5 E0                 lda   IUserID                  ;set up direct page for private call
0444 B683 85 E2                 sta   input_parms+2            ;UserID
0445 B685 A9 00 80              lda   #$8000
0446 B688 85 E0                 sta   input_parms              ;Quit Flag
0447 B68A 20 9F AE              jsr   myUserShutdown           ;call private function
0448 B68D 68                    pla                            ;retrieve UserID returned from _UserShutdown
0449 B68E 20 20 FB              jsr   restore_dp               ;restore direct page
0450 B691              ;
0451 B691              ;        remove UserID from Pathname Table (Shutdown didn't do this)
0452 B691              ;
0453 B691 48                    pha                            ;put UserID back on stack
0454 B692 F4 01 00              pea   PATHTBL>>16
0455 B695 F4 B2 A6              pea   |PATHTBL
0456 B698 20 C8 F8              jsr   Remove_UserID
0457 B69B              ;
0458 B69B              ;       if pathname is NULL (i.e. Memory Loaded file), exit with No Find error
0459 B69B              ;
0460 B69B A5 18                 lda   TempBuff
0461 B69D 05 1A                 ora   TempBuff+2
0462 B69F D0 05                 bne   cont11
0463 B6A1 A9 01 11              lda   #NoFind
0464 B6A4 80 16                 bra   Error_Exit
0465 B6A6              ;
0466 B6A6              ;        do InitialLoad
0467 B6A6              ;
0468 B6A6              cont11    
0469 B6A6              ; space is already on stack for return parameters
0470 B6A6              ;        lda     #0
0471 B6A6              ;        pha                            ;output UserID
0472 B6A6              ;        pha                            ;output Starting Address (0)
0473 B6A6              ;        pha
0474 B6A6              ;        pha                            ;output Zero Page/Stack info (0)
0475 B6A6              ;        pha
0476 B6A6 A5 E0                 lda   IUserID                  ;fill in input_parms for InitalLoad
0477 B6A8 85 E8                 sta   input_parms+8            ;UserID
0478 B6AA A5 1A                 lda   TempBuff+2
0479 B6AC 85 E6                 sta   input_parms+6            ;buffer address
0480 B6AE A5 18                 lda   TempBuff
0481 B6B0 85 E4                 sta   input_parms+4
0482 B6B2 64 E2                 stz   input_parms+2            ;Special Memory flag
0483 B6B4 A9 01 00              lda   #1
0484 B6B7 85 E0                 sta   input_parms              ;Input Type
0485 B6B9 20 00 B1              jsr   myInitLoad               ;do the InitialLoad
0486 B6BC              ;
0487 B6BC              ;        error exit
0488 B6BC              ;
0489 B6BC 4B           Error_Exit phk                          ;restore DBR
0490 B6BD AB                    plb   
0491 B6BE 48                    pha                            ;save return status
0492 B6BF F4 08 70              pea   uTempBuff                ;dispose of any temporary memory buffers
0493 B6C2 A2 02 11 22           _DisposeAll 
0494 B6C9 68                    pla                            ;retrieve original return status
0495 B6CA 4C 1B BA              jmp   return_to_caller
0496 B6CD
0497 B6CD              ;-----------------------------------------------------------------------------------------
0498 B6CD
0499 B6CD              kick_start  
0500 B6CD                       Import chk_dynamic_seg,open_load_file,save_ref_num, \
0501 B6CD                       make_HET_ptr, reset_jmp_tables,reload_inits, \ 
0502 B6CD                       reload_restart, restore_start,close_load_file 
0503 B6CD
0504 B6CD 64 B4                 stz   file_open                ;indicate that the file is closed
0505 B6CF 9C A6 A6              stz   starting_addr            ;reset all of our variables
0506 B6D2 9C A8 A6              stz   starting_addr+2
0507 B6D5 64 DA                 stz   stack_addr               ;there is no stack
0508 B6D7 64 DC                 stz   stack_size
0509 B6D9
0510 B6D9 20 E6 DB              jsr   chk_dynamic_seg          ;does the file contain any dynamic segments
0511 B6DC B0 08                 bcs   @no_dynamics
0512 B6DE
0513 B6DE 20 69 DD              jsr   open_load_file           ;open the file please
0514 B6E1 B0 17                 bcs   @error_out               ;report error to the caller.
0515 B6E3 20 F4 DB              jsr   save_ref_num
0516 B6E6              @no_dynamics  
0517 B6E6 20 44 D2              jsr   make_HET_ptr             ;make pointer to Header Entry Table
0518 B6E9 20 35 DF              jsr   reset_jmp_tables         ;delete any references to dynamic segments
0519 B6EC 20 85 E4              jsr   reload_inits             ;please restart any init segments
0520 B6EF B0 09                 bcs   @error_out
0521 B6F1 20 43 E4              jsr   reload_restart           ;please reload any restart segments.
0522 B6F4 B0 04                 bcs   @error_out
0523 B6F6 20 24 E4              jsr   restore_start
0524 B6F9 18                    clc   
0525 B6FA              @error_out  
0526 B6FA 08                    php   
0527 B6FB 48                    pha   
0528 B6FC A5 B4                 lda   file_open                ;is the file open?
0529 B6FE F0 03                 beq   @skip_close
0530 B700 20 2E DD              jsr   close_load_file
0531 B703              @skip_close  
0532 B703 68                    pla   
0533 B704 28                    plp   
0534 B705 60                    rts   
0535 B706
0536 B706              ;====================================================================================================
0537 B706              ;chk_mod_date:  compares modification date of file (from GetFileInfo) against date
0538 B706              ;               stored within ExpressLoad segment in memory
0539 B706              ;
0540 B706              chk_mod_date  
0541 B706                       Import lock_handles,unlock_handles
0542 B706
0543 B706 20 62 BA              jsr   lock_handles             ;lock down Express segment
0544 B709
0545 B709 A9 07 00              lda   #$0007                   ;7 parms for GetFileInfo call
0546 B70C 8D 8A A7              sta   PGetFileInfo.pCount
0547 B70F A5 CE                 lda   PathnamePtr
0548 B711 8D 8C A7              sta   PGetFileInfo.pathname
0549 B714 38                    sec   
0550 B715 E9 08 00              sbc   #8                       ;mod date is stored 8 bytes before pathname
0551 B718 85 62                 sta   temp_ptr                 ;set up pointer for eventual comparison
0552 B71A A5 D0                 lda   PathnamePtr+2
0553 B71C 8D 8E A7              sta   PGetFileInfo.pathname+2
0554 B71F E9 00 00              sbc   #0
0555 B722 85 64                 sta   temp_ptr+2
0556 B724 22 A8 00 E1           jsl   $E100A8                  ;make the call
0557 B728 06 20                 DC W:GetFileInfo
0558 B72A 8A A7 01 00           DC L:PGetFileInfo
0559 B72E AA                    tax                            ;clear Z flag on error
0560 B72F B0 10                 bcs   no_good                  ;just abort on error
0561 B731
0562 B731              ; now that we have the file's mod date in memory, set up a pointer to the buffered
0563 B731              ; mod date in the ExpressLoad segment
0564 B731
0565 B731 A0 06 00              ldy   #6                       ;compare 8 bytes
0566 B734              @loop     
0567 B734 B7 62                 lda   [temp_ptr],y             ;get a word
0568 B736 D9 A2 A7              cmp   PGetFileInfo.modDateTime,y
0569 B739 D0 06                 bne   no_good                  ;exit if unequal
0570 B73B 88                    dey   
0571 B73C 88                    dey                            ;loop through entire field
0572 B73D 10 F5                 bpl   @loop
0573 B73F E2 02                 sep   #%00000010               ;set Z flag to show they're equal
0574 B741              no_good   
0575 B741 08                    php                            ;save return status
0576 B742 20 CB BA              jsr   unlock_handles           ;unlock the handles again
0577 B745 28                    plp                            ;return status
0578 B746 60                    rts   
0579 B747
0580 B747                       ENDP 
0581 B747
